﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_PytaniezObrazkiem : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {

            }

            public int id { get; set; }
            public string text { get; set; }
            public string correct { get; set; }
            public string answers { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_PytaniezObrazkiem(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
            
        }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Points: MovingBox_PointsLoad(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Points: MovingBox_PointsCheck(ContextParam.ExerciseOut, ListExerciseDataSave); break;
                }

                SetExerciseOwlSave();
            }
        }

        private void MovingBox_PointsLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            string _loopBoxValue;
            int _loopX;
            int _loopY;

            XmlNode _xmlArea = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Area);


            ExerciseDataStub _imageStub = new ExerciseDataStub();
            _imageStub.id = _stubIndex;
            _imageStub.text = Gemini.Utility.XML.Attribute.Get.String(_xmlArea, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ImageURL);
            ExerciseData.Add(_imageStub);   

            XmlNodeList _listXmlBox = _xmlArea.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box);
            foreach (XmlNode _loopXmlBox in _listXmlBox)
            {
                _stubIndex++;
                _loopBoxValue = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlBox, String.Empty);
                _loopX = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlBox, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.X);
                _loopY = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlBox, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.Y);

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.text = string.Format("{0}x{1}", _loopX, _loopY);
                _loopStub.correct = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlBox, String.Empty);

                ExerciseData.Add(_loopStub);   
            }


            XmlNode _xmlExtraBox = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Extra_Box);
            XmlNodeList _listXmlExtraBox = _xmlExtraBox.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box);

            foreach (XmlNode _loopXmlExtraBox in _listXmlExtraBox)
            {
                _stubIndex++;
                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.text = String.Empty;
                _loopStub.correct = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlExtraBox, String.Empty);

                ExerciseData.Add(_loopStub);
            }
        }

        private void MovingBox_PointsCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            string _loopXY;
            int _loopX;
            int _loopY;
            int _stubIndex = 0;

            Exercise.TmpPoints = 0;

            Dictionary<string, string> _dictionaryPointText = new Dictionary<string, string>();

            XmlNode _xmlArea = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Area);
            XmlNodeList _listXmlBox = _xmlArea.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box);
            foreach (XmlNode _loopXmlBox in _listXmlBox)
            {
                _loopX = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlBox, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.X);
                _loopY = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlBox, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.Y);
                _loopXY = string.Format("{0}x{1}", _loopX, _loopY);

                if (!_dictionaryPointText.ContainsKey(_loopXY))
                {
                    _dictionaryPointText.Add(_loopXY, Gemini.Utility.XML.Node.Get.CDATA(_loopXmlBox, String.Empty));
                }
            }

            string _ansverXY = string.Empty;
            string _ansverText = string.Empty;
            bool _isCorrect = false;

            foreach (GExerciseDataCheckOne _loopExerciseDataSav in ListExerciseDataSave)
            {
                _isCorrect = false;

                if (_loopExerciseDataSav.answers.Count > 1)
                {
                    _ansverXY = _loopExerciseDataSav.answers[0];
                    _ansverText = _loopExerciseDataSav.answers[1];

                    if (_dictionaryPointText.ContainsKey(_ansverXY))
                    {
                        if (_dictionaryPointText[_ansverXY] == _ansverText)
                        {
                            Exercise.TmpPoints++;
                            _isCorrect = true;
                        }
                    }

                }

                GExerciseCheck  _loopExerciseCheck = new GExerciseCheck();
                                _loopExerciseCheck.id = _stubIndex + 1;
                                _loopExerciseCheck.success_arr.Add(_isCorrect);

                ExerciseCheck.Add(_loopExerciseCheck);
                
                _stubIndex++;
            }
        }
    }
}
